<x-app-layout>
    <x-slot name="header">
        Destination
    </x-slot>

    <div class="row row-sm">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-header">
                    <a href="{{ route('admin.destination.create') }}" class="btn btn-primary">Add New</a>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table id="datatable" class="table table-bordered text-nowrap border-bottom">
                            <thead>
                                <tr>
                                    <th class="border-bottom-0">Destination</th>
                                    <th class="border-bottom-0">Packages</th>
                                    <th class="border-bottom-0">Places</th>
                                    <th class="border-bottom-0">Status</th>
                                    <th class="border-bottom-0">created At</th>
                                    <th class="border-bottom-0">Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($destinations as $destination)
                                <tr>
                                    <td>
                                        <div class="d-flex">
                                            <div class="avatar-md me-3">
                                                <img src="{{ asset($destination->thumbnail) }}"
                                                    class="rounded-4" alt="image">
                                            </div>
                                            <p>
                                                <a href="{{route('admin.destination.show', $destination->id)}}" target="__blank">{{ $destination->name }}</a>

                                            </p>
                                        </div>
                                    </td>
                                    <td>0</td>
                                    <td>{{ $destination->places_count }}</td>
                                    <td>
                                        @if ($destination->status == 1)
                                        <span class="badge bg-success">Active</span>
                                        @else
                                        <span class="badge bg-danger">Inactive</span>
                                        @endif
                                    </td>
                                    <td>{{ $destination->created_at->format('d M Y') }}</td>
                                    <td>
                                        <a href="{{ route('admin.destination.edit', $destination->id) }}"
                                            class="btn btn-primary btn-sm">Edit</a>
                                        <a href="javascript:void(0)" data-url="{{ route('admin.destination.destroy', $destination->id) }}" class="btn btn-danger confirm-me btn-sm">Delete</a>
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <x-slot name="script">
        <x-datatable-js />
        <x-confirm-js />
    </x-slot>
</x-app-layout>
